/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final Display strings;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final UFont font;
    private final HtmlColor fontColor;

    public AbstractTextualComponent(CharSequence label, FontConfiguration font, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, double maxMessageSize, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        this(Display.getWithNewlines(label == null ? "" : label.toString()), font, horizontalAlignment, marginX1, marginX2, marginY, spriteContainer, maxMessageSize, false, fontForStereotype, htmlColorForStereotype);
    }

    public AbstractTextualComponent(Display strings, FontConfiguration font, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, double maxMessageSize, boolean enhanced, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        this.font = font.getFont();
        this.fontColor = font.getColor();
        this.marginX1 = marginX1;
        this.marginX2 = marginX2;
        this.marginY = marginY;
        this.strings = strings;
        this.textBlock = strings.size() == 1 && strings.get(0).length() == 0 ? new TextBlockEmpty() : (enhanced ? new BodyEnhanced2(strings, FontParam.NOTE, spriteContainer, HorizontalAlignment.LEFT, font) : strings.create(font, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, fontForStereotype, htmlColorForStereotype));
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getHeight() + (double)(2 * this.marginY);
    }

    protected final Display getLabels() {
        return this.strings;
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HtmlColor getFontColor() {
        return this.fontColor;
    }
}

